using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Globalization;
namespace kvadrati
{
    class Program
    {
        private static void Quick_Sort(float[] arr, int[] arr2, int left, int right)
        {
            if (left < right)
            {
                int pivot = Partition(arr, arr2, left, right);

                if (pivot > 1)
                {
                    Quick_Sort(arr, arr2, left, pivot - 1);
                }
                if (pivot + 1 < right)
                {
                    Quick_Sort(arr, arr2, pivot + 1, right);
                }
            }
        }

        private static int Partition(float[] arr, int[] arr2, int left, int right)
        {
            float pivot = arr[left];
            while (true)
            {

                while (arr[left] < pivot)
                {
                    left++;
                }

                while (arr[right] > pivot)
                {
                    right--;
                }

                if (left < right)
                {
                    if (arr[left] == arr[right]) return right;

                    int temp2 = arr2[left];
                    arr2[left] = arr2[right];
                    arr2[right] = temp2;

                    float temp = arr[left];
                    arr[left] = arr[right];
                    arr[right] = temp;
                }
                else
                {
                    return right;
                }
            }
        }

        static void Main(string[] args)
        {

            int N = int.Parse(Console.ReadLine());
            int i;
            int[] A = new int[N];
            float[] P = new float[N];
            double[] keresetek = new double[N];

            //Beolvasas
            for (i = 0; i < N; i++)
            {
                string[] sor = Console.ReadLine().Split(' ');
                A[i] = int.Parse(sor[0]);
                P[i] = float.Parse(sor[1], CultureInfo.InvariantCulture.NumberFormat);
                keresetek[i] = 0;
            }

            //Szazalekok sorbarendezese
            Quick_Sort(P,A, 0, P.Length - 1);

            double max = -1;
            //Keresetek szamitasa szazalekonkent
            for (i = N - 1; i >= 0; i--)
            {
                int penz = 0;
                for(int j = i; j < N; j++)
                {
                    penz += A[j];
                }
                keresetek[i] = ((double)penz * P[i])/100;
                if (keresetek[i] > max)
                {
                    max = keresetek[i];
                }
            }

            //Keresetek összehasonlítása
            Console.WriteLine("{0:0.0000}", max);
            //Console.ReadLine();
        }
    }
}